-- MySQL Administrator dump 1.4
--
-- ------------------------------------------------------
-- Server version	5.7.18-log


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;



--
-- Definition of table `bookings`
--

DROP TABLE IF EXISTS `bookings`;
CREATE TABLE `bookings` (
  `idbookings` int(11) NOT NULL AUTO_INCREMENT,
  `fromDate` date NOT NULL,
  `toDate` date NOT NULL,
  `rooms_idrooms` int(11) NOT NULL,
  `client_idclient` int(11) NOT NULL,
  PRIMARY KEY (`idbookings`),
  KEY `fk_bookings_rooms_idx` (`rooms_idrooms`),
  KEY `fk_bookings_client1_idx` (`client_idclient`),
  CONSTRAINT `fk_bookings_client1` FOREIGN KEY (`client_idclient`) REFERENCES `client` (`idclient`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_bookings_rooms` FOREIGN KEY (`rooms_idrooms`) REFERENCES `rooms` (`idrooms`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `bookings`
--

/*!40000 ALTER TABLE `bookings` DISABLE KEYS */;
INSERT INTO `bookings` (`idbookings`,`fromDate`,`toDate`,`rooms_idrooms`,`client_idclient`) VALUES 
 (1,'2020-11-08','2020-11-08',1,2),
 (2,'2020-11-08','2020-11-09',2,6),
 (3,'2020-12-13','2020-12-14',9,1),
 (4,'2020-11-25','2020-11-26',10,6),
 (5,'2020-11-24','2020-11-27',9,2),
 (6,'2020-11-24','2020-11-27',6,4),
 (7,'2020-11-24','2020-11-27',5,4),
 (8,'2020-11-23','2020-11-24',8,6),
 (9,'2020-11-17','2020-11-21',10,1),
 (10,'2020-11-18','2020-11-20',1,1),
 (11,'2020-11-18','2020-11-20',13,1),
 (12,'2020-11-10','2020-11-10',1,1),
 (13,'2020-11-10','2020-11-10',2,1),
 (14,'2020-11-10','2020-11-21',9,1),
 (15,'2020-11-10','2020-11-12',5,2);
/*!40000 ALTER TABLE `bookings` ENABLE KEYS */;


--
-- Definition of table `catalog`
--

DROP TABLE IF EXISTS `catalog`;
CREATE TABLE `catalog` (
  `idcatalog` int(11) NOT NULL AUTO_INCREMENT,
  `super_catalog_idsuper_catalog` int(11) NOT NULL,
  `language` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `catalog_num` int(11) NOT NULL,
  `catalog_code` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `group_num` int(11) DEFAULT NULL,
  PRIMARY KEY (`idcatalog`),
  KEY `fk_catalog_super_catalog1_idx` (`super_catalog_idsuper_catalog`),
  KEY `idx1_catalog` (`super_catalog_idsuper_catalog`,`catalog_num`),
  KEY `idx2_catalog` (`super_catalog_idsuper_catalog`,`catalog_code`),
  KEY `idx3_catalog` (`group_num`,`super_catalog_idsuper_catalog`),
  CONSTRAINT `fk_catalog_super_catalog1` FOREIGN KEY (`super_catalog_idsuper_catalog`) REFERENCES `super_catalog` (`idsuper_catalog`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `catalog`
--

/*!40000 ALTER TABLE `catalog` DISABLE KEYS */;
INSERT INTO `catalog` (`idcatalog`,`super_catalog_idsuper_catalog`,`language`,`catalog_num`,`catalog_code`,`description`,`group_num`) VALUES 
 (1,1,'',0,'English','Inglés',NULL),
 (2,1,'',1,'Spanish','Español',NULL),
 (7,3,'English',0,'Not','no',NULL),
 (8,3,'English',1,'Yes','sí',NULL),
 (9,3,'Spanish',0,'No','',NULL),
 (10,3,'Spanish',1,'Sí','',NULL),
 (11,4,'English',0,'Double','',NULL),
 (12,4,'English',1,'Single','',NULL),
 (13,4,'English',2,'Suite','',NULL),
 (14,4,'English',3,'Royal','',NULL),
 (15,4,'Spanish',0,'Doble','',NULL),
 (16,4,'Spanish',1,'Individual','',NULL),
 (17,4,'Spanish',2,'Suite','',NULL),
 (18,4,'Spanish',3,'Suite Real','',NULL),
 (19,5,'English',0,'Double','',NULL),
 (20,5,'English',1,'Big-size','',NULL),
 (21,5,'English',2,'King-size','',NULL),
 (22,5,'English',3,'Water','',NULL),
 (23,5,'Spanish',0,'Doble','',NULL),
 (24,5,'Spanish',1,'Matrimonio','',NULL),
 (25,5,'Spanish',2,'Extra grande','',NULL),
 (26,5,'Spanish',3,'Agua','',NULL),
 (27,6,'English',0,'Not','',NULL),
 (28,6,'English',1,'Yes','',NULL),
 (29,6,'Spanish',0,'No','',NULL),
 (30,6,'Spanish',1,'Sí','',NULL),
 (31,7,'English',0,'Not','',NULL),
 (32,7,'English',1,'Yes','',NULL),
 (33,7,'Spanish',0,'No','',NULL),
 (34,7,'Spanish',1,'Sí','',NULL),
 (35,5,'English',4,'Single','',NULL),
 (36,5,'Spanish',4,'Simple','',NULL);
/*!40000 ALTER TABLE `catalog` ENABLE KEYS */;


--
-- Definition of table `client`
--

DROP TABLE IF EXISTS `client`;
CREATE TABLE `client` (
  `idclient` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `taxIdentification` varchar(15) NOT NULL,
  `phone` varchar(100) NOT NULL,
  `address1` varchar(100) NOT NULL,
  `address2` varchar(100) DEFAULT NULL,
  `country` varchar(50) DEFAULT NULL,
  `observation` varchar(400) DEFAULT NULL,
  PRIMARY KEY (`idclient`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `client`
--

/*!40000 ALTER TABLE `client` DISABLE KEYS */;
INSERT INTO `client` (`idclient`,`name`,`taxIdentification`,`phone`,`address1`,`address2`,`country`,`observation`) VALUES 
 (1,'Fernando Humanes','00000004M','+34360360360','Calle del Pez',NULL,'Spain',NULL),
 (2,'Fernando Humanes 2','20000004M','+34360360360','Calle del Pez',NULL,'Spain',NULL),
 (3,'Fernando Humanes 3','30000004M','+34360360360','Calle del Pez',NULL,'Spain',NULL),
 (4,'Fernando Humanes 4','40000004M','+34360360360','Calle del Pez',NULL,'Spain',NULL),
 (5,'Fernando Humanes 5','50000004M','+34360360360','Calle del Pez',NULL,'Spain',NULL),
 (6,'Fernando Humanes6','60000004M','+34360360360','Calle del Pez',NULL,'Spain',NULL),
 (7,'Fernando Humanes 7','70000004M','+34360360360','Calle del Pez',NULL,'Spain',NULL),
 (8,'Fernando Humanes 8','80000004M','+34360360360','Calle del Pez',NULL,'Spain',NULL),
 (9,'Fernando Humanes 9','90000004M','+34360360360','Calle del Pez',NULL,'Spain',NULL),
 (10,'Fernando Humanes 10','10000004M','+34630630630','dede',NULL,'Spain',NULL);
/*!40000 ALTER TABLE `client` ENABLE KEYS */;


--
-- Definition of table `config`
--

DROP TABLE IF EXISTS `config`;
CREATE TABLE `config` (
  `config_id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `value` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `group` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `type` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`config_id`),
  UNIQUE KEY `config_name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `config`
--

/*!40000 ALTER TABLE `config` DISABLE KEYS */;
INSERT INTO `config` (`config_id`,`name`,`value`,`group`,`type`,`description`) VALUES 
 (1,'URL','http://localhost/hotel','','',NULL),
 (3,'PLUGIN_ICON','mis_imagenes','','',NULL),
 (7,'CALENDAR_LANGUAGE','en','','','Calendar Language, default=en, especial = es'),
 (8,'CALENDAR_FIRST_DAY','0','','','0 = Sun\r\n1 = Monday');
/*!40000 ALTER TABLE `config` ENABLE KEYS */;


--
-- Definition of table `hotel_audit`
--

DROP TABLE IF EXISTS `hotel_audit`;
CREATE TABLE `hotel_audit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `datetime` datetime NOT NULL,
  `ip` varchar(40) NOT NULL,
  `user` varchar(300) DEFAULT NULL,
  `table` varchar(300) DEFAULT NULL,
  `action` varchar(250) NOT NULL,
  `description` mediumtext,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `hotel_audit`
--

/*!40000 ALTER TABLE `hotel_audit` DISABLE KEYS */;
/*!40000 ALTER TABLE `hotel_audit` ENABLE KEYS */;


--
-- Definition of table `hotel_settings`
--

DROP TABLE IF EXISTS `hotel_settings`;
CREATE TABLE `hotel_settings` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `TYPE` int(11) DEFAULT '1',
  `NAME` mediumtext,
  `USERNAME` mediumtext,
  `COOKIE` varchar(500) DEFAULT NULL,
  `SEARCH` mediumtext,
  `TABLENAME` varchar(300) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `hotel_settings`
--

/*!40000 ALTER TABLE `hotel_settings` DISABLE KEYS */;
INSERT INTO `hotel_settings` (`ID`,`TYPE`,`NAME`,`USERNAME`,`COOKIE`,`SEARCH`,`TABLENAME`) VALUES 
 (1,2,NULL,'admin',NULL,'{\"gridWidth\":665.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":20.4,\"grid_headcell_details\":33.4,\"grid_headcell_field\":29.4,\"grid_headcell_field1\":48.4,\"grid_headcell_field2\":39.4,\"grid_headcell_field3\":68.4,\"grid_headcell_field4\":64.4,\"grid_headcell_field5\":75.4,\"grid_headcell_field6\":64.4,\"grid_headcell_field7\":90.4}}','rooms'),
 (2,2,NULL,'admin',NULL,'{\"gridWidth\":1118.4,\"thWidths\":{\"grid_headcell_icons\":41.4,\"grid_headcell_checkbox\":20.4,\"grid_headcell_details\":33.4,\"grid_headcell_field\":12.4,\"grid_headcell_field1\":238.4,\"grid_headcell_field2\":96.4,\"grid_headcell_field3\":102.4,\"grid_headcell_field6\":125.4,\"grid_headcell_field4\":146.4,\"grid_headcell_field5\":206.4}}','client'),
 (3,2,NULL,'admin',NULL,'{\"gridWidth\":528.4,\"thWidths\":{\"grid_headcell_icons\":12.4,\"grid_headcell_checkbox\":13.4,\"grid_headcell_field\":13.4,\"grid_headcell_field1\":33.4,\"grid_headcell_field2\":188.4,\"grid_headcell_field3\":92.4,\"grid_headcell_field4\":108.4}}','bookings'),
 (4,2,NULL,'admin',NULL,'{\"gridWidth\":463.4,\"thWidths\":{\"grid_headcell_icons\":20.4,\"grid_headcell_field\":12.4,\"grid_headcell_field1\":55.4,\"grid_headcell_field3\":64.4,\"grid_headcell_field4\":52.4,\"grid_headcell_field5\":59.4,\"grid_headcell_field6\":54.4,\"grid_headcell_field7\":68.4}}','v_roomSearch'),
 (5,2,NULL,'admin',NULL,'{\"gridWidth\":652.4,\"thWidths\":{\"grid_headcell_icons\":62.4,\"grid_headcell_field1\":90.4,\"grid_headcell_field3\":168.4,\"grid_headcell_field4\":100.4,\"grid_headcell_field5\":56.4,\"grid_headcell_field6\":56.4,\"grid_headcell_field7\":51.4}}','roomSearch'),
 (6,2,NULL,'admin',NULL,'{\"gridWidth\":608,\"thWidths\":{\"grid_headcell_icons\":22,\"grid_headcell_field1\":33,\"grid_headcell_field3\":166,\"grid_headcell_field4\":89,\"grid_headcell_field5\":101,\"grid_headcell_field6\":95,\"grid_headcell_field7\":46}}','Reserve_roomsearch_list'),
 (7,2,NULL,'admin',NULL,'{\"gridWidth\":866.4,\"thWidths\":{\"grid_headcell_icons\":20.4,\"grid_headcell_checkbox\":20.4,\"grid_headcell_field\":9.4,\"grid_headcell_field1\":131.4,\"grid_headcell_field2\":198.4,\"grid_headcell_field3\":35.4,\"grid_headcell_field4\":24.4,\"grid_headcell_field5\":350.4}}','config'),
 (8,2,NULL,'admin',NULL,'{\"gridWidth\":599.4,\"thWidths\":{\"grid_headcell_icons\":20.4,\"grid_headcell_checkbox\":20.4,\"grid_headcell_details\":40.4,\"grid_headcell_field\":9.4,\"grid_headcell_field1\":72.4,\"grid_headcell_field2\":379.4}}','super_catalog');
/*!40000 ALTER TABLE `hotel_settings` ENABLE KEYS */;


--
-- Definition of table `hotel_uggroups`
--

DROP TABLE IF EXISTS `hotel_uggroups`;
CREATE TABLE `hotel_uggroups` (
  `GroupID` int(11) NOT NULL AUTO_INCREMENT,
  `Label` varchar(300) DEFAULT NULL,
  PRIMARY KEY (`GroupID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `hotel_uggroups`
--

/*!40000 ALTER TABLE `hotel_uggroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `hotel_uggroups` ENABLE KEYS */;


--
-- Definition of table `hotel_ugmembers`
--

DROP TABLE IF EXISTS `hotel_ugmembers`;
CREATE TABLE `hotel_ugmembers` (
  `UserName` varchar(300) NOT NULL,
  `GroupID` int(11) NOT NULL,
  PRIMARY KEY (`UserName`(50),`GroupID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `hotel_ugmembers`
--

/*!40000 ALTER TABLE `hotel_ugmembers` DISABLE KEYS */;
INSERT INTO `hotel_ugmembers` (`UserName`,`GroupID`) VALUES 
 ('admin',-1);
/*!40000 ALTER TABLE `hotel_ugmembers` ENABLE KEYS */;


--
-- Definition of table `hotel_ugrights`
--

DROP TABLE IF EXISTS `hotel_ugrights`;
CREATE TABLE `hotel_ugrights` (
  `TableName` varchar(300) NOT NULL,
  `GroupID` int(11) NOT NULL,
  `AccessMask` varchar(10) DEFAULT NULL,
  `Page` mediumtext,
  PRIMARY KEY (`TableName`(50),`GroupID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `hotel_ugrights`
--

/*!40000 ALTER TABLE `hotel_ugrights` DISABLE KEYS */;
INSERT INTO `hotel_ugrights` (`TableName`,`GroupID`,`AccessMask`,`Page`) VALUES 
 ('bookings',-1,'ADESPIM',NULL),
 ('catalog',-1,'ADESPIM',NULL),
 ('client',-1,'ADESPIM',NULL),
 ('config',-1,'ADESPIM',NULL),
 ('lv_cartalog',-1,'ADESPIM',NULL),
 ('Reserve',-1,'S',NULL),
 ('rooms',-1,'ADESPIM',NULL),
 ('roomSearch',-1,'AES',NULL),
 ('super_catalog',-1,'ADESPIM',NULL),
 ('timeline',-1,'S',NULL),
 ('users',-1,'ADESPIM',NULL),
 ('v_roomSearch',-1,'AES',NULL);
/*!40000 ALTER TABLE `hotel_ugrights` ENABLE KEYS */;


--
-- Definition of table `rooms`
--

DROP TABLE IF EXISTS `rooms`;
CREATE TABLE `rooms` (
  `idrooms` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(10) NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `type` varchar(10) NOT NULL,
  `bed` varchar(10) NOT NULL,
  `smoker` varchar(10) NOT NULL,
  `adapted` varchar(10) NOT NULL,
  `color` varchar(7) NOT NULL DEFAULT '#3AA8E8',
  PRIMARY KEY (`idrooms`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `rooms`
--

/*!40000 ALTER TABLE `rooms` DISABLE KEYS */;
INSERT INTO `rooms` (`idrooms`,`code`,`description`,`type`,`bed`,`smoker`,`adapted`,`color`) VALUES 
 (1,'101',NULL,'0','1','0','0','#3AA8E8'),
 (2,'102',NULL,'0','1','0','1','#AF49DE'),
 (3,'103',NULL,'0','1','0','1','#AF49DE'),
 (4,'201',NULL,'1','4','1','0','#19E854'),
 (5,'202',NULL,'1','4','1','0','#19E854'),
 (6,'203',NULL,'1','4','1','0','#19E854'),
 (7,'301',NULL,'2','1','1','0','#ED17B0'),
 (8,'302',NULL,'2','1','1','0','#ED17B0'),
 (9,'303',NULL,'3','2','1','0','#2AE8E2'),
 (10,'401',NULL,'2','3','0','0','#E0C426'),
 (11,'402',NULL,'2','3','0','0','#E0C426'),
 (12,'403',NULL,'2','3','0','0','#E0C426'),
 (13,'204',NULL,'0','1','0','0','#3AA8E8'),
 (14,'205',NULL,'0','1','0','0','#3AA8E8');
/*!40000 ALTER TABLE `rooms` ENABLE KEYS */;


--
-- Definition of table `super_catalog`
--

DROP TABLE IF EXISTS `super_catalog`;
CREATE TABLE `super_catalog` (
  `idsuper_catalog` int(11) NOT NULL AUTO_INCREMENT,
  `super_code` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`idsuper_catalog`),
  UNIQUE KEY `super_catalog_ixd1` (`super_code`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `super_catalog`
--

/*!40000 ALTER TABLE `super_catalog` DISABLE KEYS */;
INSERT INTO `super_catalog` (`idsuper_catalog`,`super_code`,`description`) VALUES 
 (1,'LANGUAGE','Idiomas de los literales'),
 (3,'DECISION','Afirmativo y negativo'),
 (4,'TYPE_ROOM','Tipo Habitación (doble, site, etc.)'),
 (5,'BED','Tipo de cama y número de ellas'),
 (6,'SMOKER','Fumadores?'),
 (7,'ADAPTED','Adaptada para mayores o minusvalias');
/*!40000 ALTER TABLE `super_catalog` ENABLE KEYS */;


--
-- Definition of table `users`
--

DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `idusers` int(11) NOT NULL AUTO_INCREMENT,
  `login` varchar(16) NOT NULL,
  `password` varchar(100) NOT NULL,
  `name` varchar(60) NOT NULL,
  PRIMARY KEY (`idusers`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `users`
--

/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` (`idusers`,`login`,`password`,`name`) VALUES 
 (1,'admin','21232f297a57a5a743894a0e4a801fc3','Fernando Humanes');
/*!40000 ALTER TABLE `users` ENABLE KEYS */;




/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
